/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PressurizedReactionRecipeSerializer<RECIPE extends PressurizedReactionRecipe>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public PressurizedReactionRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonElement ticks;
        JsonArray itemInput = GsonHelper.m_13885_((JsonObject)json, (String)"itemInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"itemInput") : GsonHelper.m_13930_((JsonObject)json, (String)"itemInput");
        ItemStackIngredient solidIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)itemInput);
        JsonArray fluidInput = GsonHelper.m_13885_((JsonObject)json, (String)"fluidInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"fluidInput") : GsonHelper.m_13930_((JsonObject)json, (String)"fluidInput");
        FluidStackIngredient fluidIngredient = (FluidStackIngredient)IngredientCreatorAccess.fluid().deserialize((JsonElement)fluidInput);
        JsonArray gasInput = GsonHelper.m_13885_((JsonObject)json, (String)"gasInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"gasInput") : GsonHelper.m_13930_((JsonObject)json, (String)"gasInput");
        ChemicalStackIngredient.GasStackIngredient gasIngredient = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().deserialize((JsonElement)gasInput);
        FloatingLong energyRequired = FloatingLong.ZERO;
        if (json.has("energyRequired")) {
            energyRequired = SerializerHelper.getFloatingLong(json, "energyRequired");
        }
        if (!GsonHelper.m_13872_((JsonElement)(ticks = json.get("duration")))) {
            throw new JsonSyntaxException("Expected duration to be a number greater than zero.");
        }
        int duration = ticks.getAsJsonPrimitive().getAsInt();
        if (duration <= 0) {
            throw new JsonSyntaxException("Expected duration to be a number greater than zero.");
        }
        ItemStack itemOutput = ItemStack.f_41583_;
        GasStack gasOutput = GasStack.EMPTY;
        if (json.has("itemOutput")) {
            itemOutput = SerializerHelper.getItemStack(json, "itemOutput");
            if (itemOutput.m_41619_()) {
                throw new JsonSyntaxException("Reaction chamber item output must not be empty, if it is defined.");
            }
            if (json.has("gasOutput") && (gasOutput = SerializerHelper.getGasStack(json, "gasOutput")).isEmpty()) {
                throw new JsonSyntaxException("Reaction chamber gas output must not be empty, if it is defined.");
            }
        } else {
            gasOutput = SerializerHelper.getGasStack(json, "gasOutput");
            if (gasOutput.isEmpty()) {
                throw new JsonSyntaxException("Reaction chamber gas output must not be empty, if there is no item output.");
            }
        }
        return this.factory.create(recipeId, solidIngredient, fluidIngredient, gasIngredient, energyRequired, duration, itemOutput, gasOutput);
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        try {
            ItemStackIngredient inputSolid = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
            FluidStackIngredient inputFluid = (FluidStackIngredient)IngredientCreatorAccess.fluid().read(buffer);
            ChemicalStackIngredient.GasStackIngredient inputGas = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().read(buffer);
            FloatingLong energyRequired = FloatingLong.readFromBuffer(buffer);
            int duration = buffer.m_130242_();
            ItemStack outputItem = buffer.m_130267_();
            GasStack outputGas = GasStack.readFromPacket(buffer);
            return this.factory.create(recipeId, inputSolid, inputFluid, inputGas, energyRequired, duration, outputItem, outputGas);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading pressurized reaction recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull RECIPE recipe) {
        try {
            ((PressurizedReactionRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing pressurized reaction recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends PressurizedReactionRecipe> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient var2, FluidStackIngredient var3, ChemicalStackIngredient.GasStackIngredient var4, FloatingLong var5, int var6, ItemStack var7, GasStack var8);
    }
}

